﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace 電子文書回覧追跡ツール
{
    public partial class Folder : Form
    {
        Form1 form1;
        public Folder(Form1 form1)
        {
            InitializeComponent();
            this.form1 = form1;
        }

        const string commonparameterfolder = @"\\tbanvisv63\DocumentControl\";

        public void 構成入手(ref List<string> servers,ref int serverPort ,ref int watchPort,ref int trackPort, ref List<string> networks,ref string untachableFolder)
        {
            //server = dataSet1.Tables["構成"].Rows[0]["管理サーバ"].ToString();
            serverPort = Convert.ToInt32( dataSet1.Tables["構成"].Rows[0]["ポート"] );
            trackPort = Convert.ToInt32(dataSet1.Tables["構成"].Rows[1]["ポート"]);
            watchPort = Convert.ToInt32(dataSet1.Tables["構成"].Rows[2]["ポート"]);
            for (int i = 0; i < dataSet1.Tables["構成"].Rows.Count; i++)
            {
                if(dataSet1.Tables["構成"].Rows[i]["ネットワーク"].ToString() != "") {
                    networks.Add(dataSet1.Tables["構成"].Rows[i]["ネットワーク"].ToString());
                }
                if(dataSet1.Tables["構成"].Rows[i]["管理サーバ"].ToString() != "") {
                    servers.Add(dataSet1.Tables["構成"].Rows[i]["管理サーバ"].ToString());
                }
            }
            try {
                untachableFolder = dataSet1.Tables["構成"].Rows[0]["不可フォルダ"].ToString();
            }catch{
                untachableFolder = string.Empty;
            }
        }

        public void パラメータ入手()
        {
            dataSet1 = CommonParameter.read();
            lblキャッシュmsg.Text = CommonParameter.message;
            this.dataGridView1.DataSource = dataSet1.Tables["追跡対象"]; //テーブル名はＸＭＬより
            //
            form1.types.Clear();
            form1.folders.Clear();
            form1.reaches.Clear();
            for(int i = 0; i < dataSet1.Tables["追跡対象"].Rows.Count; i++) {
                form1.types.Add(dataSet1.Tables["追跡対象"].Rows[i]["文書種類"].ToString());
                form1.folders.Add(dataSet1.Tables["追跡対象"].Rows[i]["最上位ディレクトリ"].ToString().ToUpper());
                form1.reaches.Add(dataSet1.Tables["追跡対象"].Rows[i]["到着待ちディレクトリ"].ToString().ToUpper());
            }
            return;

        }


        public void パラメータ反映()
        {
            form1.types.Clear();
            form1.folders.Clear();
            for(int i = 0; i < dataSet1.Tables["追跡対象"].Rows.Count; i++)
            {
                form1.types.Add(dataSet1.Tables["追跡対象"].Rows[i]["文書種類"].ToString());
                form1.folders.Add(dataSet1.Tables["追跡対象"].Rows[i]["最上位ディレクトリ"].ToString().ToUpper());
                form1.reaches.Add(dataSet1.Tables["追跡対象"].Rows[i]["到着待ちディレクトリ"].ToString().ToUpper());
            }
        }

        private void btn再読込_Click(object sender, EventArgs e)
        {
            dataSet1.Clear();
            dataSet1 = CommonParameter.read();
            lblキャッシュmsg.Text = CommonParameter.message;
            
            this.dataGridView1.DataSource = dataSet1.Tables["追跡対象"];
        }

        private void btn閉じる_Click(object sender, EventArgs e)
        {
            this.Close();

        }

        private void btn追加_Click(object sender, EventArgs e)
        {
            if(txt種類.Text == "" || txtパス.Text == "" || txt到着パス.Text == "") {
                lblErrorMessage.Text = "資料種類名、ディレクトリのどれかが空白です";
                return;
            }
            DataTable t = dataSet1.Tables["追跡対象"];
            for(int i = 0; i < t.Rows.Count; i++) {
                if(t.Rows[i][0].ToString().ToUpper() == txt種類.Text.ToUpper() || t.Rows[i]["最上位ディレクトリ"].ToString().ToUpper() == txtパス.Text.ToUpper() || t.Rows[i][2].ToString().ToUpper() == txt到着パス.Text.ToUpper()) {
                    lblErrorMessage.Text = "資料種類名、ディレクトリのどれかが、既に登録しているものと重複します";
                    return;
                }
            }
            lblErrorMessage.Text = "";
            t.Rows.Add(txt種類.Text, txtパス.Text.ToUpper(), txt到着パス.Text.ToUpper());
            txt種類.Clear();
            txtパス.Clear();
            txt到着パス.Clear();

        }

        private void btn参照_Click(object sender, EventArgs e) {
            DialogResult result = folderBrowserDialog1.ShowDialog();
            if(result == System.Windows.Forms.DialogResult.OK) {
                txtパス.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void btn参照２_Click(object sender, EventArgs e) {
            DialogResult result = folderBrowserDialog1.ShowDialog();
            if(result == System.Windows.Forms.DialogResult.OK) {
                 txt到着パス.Text = folderBrowserDialog1.SelectedPath;
            }

        }

        private void dataGridView1_UserDeletingRow(object sender, DataGridViewRowCancelEventArgs e) {
            if(MessageBox.Show("削除しますか？", "行の削除", MessageBoxButtons.YesNo) == DialogResult.No) {
                e.Cancel = true;
            }
        }

        private void Folder_Load(object sender, EventArgs e)
        {
            lblErrorMessage.Text = "";
            txt種類.Text = txtパス.Text = txt到着パス.Text = "";
            if (Environment.UserName == "matsumoto01u" || Environment.UserName == "kmatsumoto4" || Environment.UserName == "ken2" || Environment.UserName == "ＫＭ")
            {
                //btn保存.Visible = true;
            }
        }

        private void btn保存_Click_1(object sender, EventArgs e) {
            using(passwordForm frm = new passwordForm()) {  
                frm.ShowDialog();
                if(frm.passwordOK) {
                    CommonParameter.write(dataSet1);
                }
            }
        }

        private void 印刷PToolStripButton_Click(object sender, EventArgs e)
        {
            form1.FormPrint( this);
        }
    }
}